/**
 * Project Name:media-biz<br>
 * File Name:ReqAccount.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年9月30日下午2:56:35<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.dto.req;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.media.api.dto.BaseQueryDto;

/**
 * ClassName: ReqAccountChange <br/>
 * date: 2016年9月30日 下午2:56:35 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqAccountChange extends BaseQueryDto {


    /**序列号*/
    private static final long serialVersionUID = -2912177105268654622L;

    /** 查询日期. */
    @ApiModelProperty(value = "查询开始日期", required = true)
    @NotNull(message="开始日期不能为空")
    private String            startDate;

    /** 查询日期. */
    @ApiModelProperty(value = "查询结束日期", required = true)
    @NotNull(message="结束日期不能为空")
    private String            endDate;

    /** 当前登陆用户mediaId */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              mediaId;


    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.6
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.6
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.6
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.6
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
