/**
 * Project Name:media-api File Name:ReqCreateMediaAppConfigDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月8日下午5:41:18 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqCreateMediaAppConfigDto <br/>
 * Function: 媒体配置信息dto. <br/>
 * Date: 2016年10月8日 下午5:41:18 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqCreateMediaAppConfigDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 1266835938062803589L;

    /** 媒体Id */
    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull(message = "媒体Id不能为空")
    private Long              appId;

    /** 计费方式:0-CPM;1-CPC; */
    @ApiModelProperty(value = "计费方式", required = true)
    @NotNull(message = "计费方式不能为空")
    private Integer           chargeType;

    /** 价格 */
    @ApiModelProperty(value = "价格", required = true)
    @NotNull(message = "价格不能为空")
    private Long              price;

    /** 媒体分账比例 */
    @ApiModelProperty(value = "媒体分账比例", required = true)
    @NotNull(message = "媒体分账比例不能为空")
    private Integer           mediaSplitRatio;

    /** 平台分账比例 */
    @ApiModelProperty(value = "平台分账比例", required = true)
    @NotNull(message = "平台分账比例不能为空")
    private Integer           platformSplitRatio;

    /** 0-不扣量;1-扣量;默认为1-扣量 */
    @ApiModelProperty(value = "扣量", required = true)
    @NotNull(message = "扣量不能为空")
    private Integer           isDeducted;

    /** 扣量比例：% */
    @ApiModelProperty(value = "扣量比例", required = true)
    @NotNull(message = "扣量比例不能为空")
    private Integer           deductedPercent;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Integer getMediaSplitRatio() {
        return mediaSplitRatio;
    }

    public void setMediaSplitRatio(Integer mediaSplitRatio) {
        this.mediaSplitRatio = mediaSplitRatio;
    }

    public Integer getPlatformSplitRatio() {
        return platformSplitRatio;
    }

    public void setPlatformSplitRatio(Integer platformSplitRatio) {
        this.platformSplitRatio = platformSplitRatio;
    }

    public Integer getIsDeducted() {
        return isDeducted;
    }

    public void setIsDeducted(Integer isDeducted) {
        this.isDeducted = isDeducted;
    }

    public Integer getDeductedPercent() {
        return deductedPercent;
    }

    public void setDeductedPercent(Integer deductedPercent) {
        this.deductedPercent = deductedPercent;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
