package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

/**
 * Function: RspActivityDto
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public class RspActivityDto implements Serializable {

    private static final long                 serialVersionUID = 98764557625344564L;

    /** 活动ID */
    private Long                              id;

    /** 活动名称 */
    private String                            name;

    /** 活动类型 */
    private Integer                           type;

    /** 活动类型名称 */
    private String                            typeName;

    /** 活动状态 */
    private String                            status;

    /** 广告位素材规格列表 */
    private List<Long>                        activityMsIdList;

    /** 定向模式： 0仅投放定向列表，1优先投放定向列表 */
    private Integer                           directAdvertMode;

    /** 是否定向广告券 */
    private Integer                           isDirectAdvert;

    /** 是否定向媒体 */
    private Integer                           isDirectMedia;

    /** 活动是否开启 */
    private Integer                           isEnable;

    /** 是否已发布活动计划 */
    private Integer                           isPublish;

    /** 规格内容列表 */
    private List<RspMaterialSpecificationDto> msItemContentList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Long> getActivityMsIdList() {
        return activityMsIdList;
    }

    public void setActivityMsIdList(List<Long> activityMsIdList) {
        this.activityMsIdList = activityMsIdList;
    }

    public Integer getDirectAdvertMode() {
        return directAdvertMode;
    }

    public void setDirectAdvertMode(Integer directAdvertMode) {
        this.directAdvertMode = directAdvertMode;
    }

    public Integer getIsDirectAdvert() {
        return isDirectAdvert;
    }

    public void setIsDirectAdvert(Integer isDirectAdvert) {
        this.isDirectAdvert = isDirectAdvert;
    }

    public Integer getIsDirectMedia() {
        return isDirectMedia;
    }

    public void setIsDirectMedia(Integer isDirectMedia) {
        this.isDirectMedia = isDirectMedia;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public List<RspMaterialSpecificationDto> getMsItemContentList() {
        return msItemContentList;
    }

    public void setMsItemContentList(List<RspMaterialSpecificationDto> msItemContentList) {
        this.msItemContentList = msItemContentList;
    }
}
