/**
 * Project Name:media-api File Name:RspMediaAppStatistics.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月11日下午2:05:48 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: RspMediaAppStatisticsDto <br/>
 * date: 2016年10月11日 下午2:51:02 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class RspMediaAppStatisticsDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -1690834285416671390L;

    /** 应用ID. */
    private Long              appId;

    /** 应用名称. */
    private String            appName;

    /** 广告位类型. */
    private String            platform;

    /** 曝光量. */
    private Long              exposureCount;

    /** 点击数. */
    private Long              clickCount;

    /** 预计收入. */
    private Long              consumeTotal;

    /** 每一千次的有效价格. */
    private Long              eCpm;

    /** 点击单价. */
    private Long              cpc;

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * platform.
     *
     * @return the platform
     * @since JDK 1.6
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * platform.
     *
     * @param platform the platform to set
     * @since JDK 1.6
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * 
     * geteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long geteCpm() {
        return eCpm;
    }

    /**
     * 
     * seteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param eCpm
     * @since JDK 1.6
     */
    public void seteCpm(Long eCpm) {
        this.eCpm = eCpm;
    }

    /**
     * 
     * getCpc:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long getCpc() {
        return cpc;
    }

    /**
     * 
     * setCpc:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param cpc
     * @since JDK 1.6
     */
    public void setCpc(Long cpc) {
        this.cpc = cpc;
    }
}
