package cn.com.duiba.tuia.media.api.constant;

/**
 * Function: 活动类型常量
 *
 * @author xuyenan
 * @createTime 2016/10/20
 */
public class ActivityTypeConstant {

    public static final int      TYPE_DUIBA_ACTIVITY        = 0; // 专题活动
    public static final int      TYPE_TURN_TABLE            = 1; // 大转盘活动
    public static final int      TYPE_DUIBA_SINGLE_LOTTERY  = 2; // 兑吧单品抽奖
    public static final int      TYPE_APP_SINGLE_LOTTERY    = 3; // APP自有单品抽奖
    public static final int      TYPE_DUIBA_TURN_TABLE      = 4; // 兑吧大转盘
    public static final int      TYPE_APP_MANUAL_LOTTERY    = 5; // APP自有手动开奖
    public static final int      TYPE_SHAKE_LOTTERY         = 6; // 摇一摇
    public static final int      TYPE_SCRATCH_CARD          = 7; // 刮刮卡
    public static final int      TYPE_HD_TOOL_TURN_TABLE    = 8; // 活动工具大转盘
    public static final int      TYPE_HD_TOOL_TIGER         = 9; // 老虎机
    public static final int      TYPE_HD_TOOL_FLOP          = 11; // 趣味翻牌
    public static final int      TYPE_HD_TOOL_SMASHG        = 12; // 砸彩蛋
    public static final int      TYPE_SECONDS_KILL          = 30; // 周三必抢
    public static final int      TYPE_GAME_SANTA            = 20; // 游戏活动-打劫圣诞老人
    public static final int      TYPE_GAME_YEAR_AWARD       = 21; // 游戏活动-数年终奖
    public static final int      TYPE_GAME_GIRL             = 22; // 游戏活动-女神PK
    public static final int      TYPE_GAME_JIONG            = 23; // 游戏活动-人在囧途
    public static final int      TYPE_DUIBA_QUESTION_ANSWER = 40; // 兑吧答题
    public static final int      TYPE_DUIBA_QUIZZ           = 41; // 测试题
    public static final int      TYPE_DUIBA_SEC_KILL        = 31; // 兑吧秒杀活动
    public static final int      TYPE_DUIBA_NGAME           = 28; // 兑吧新游戏
    public static final int      TYPE_DUIBA_GUESS           = 42; // 兑吧竞猜
    public static final int      TYPE_DUIBA_ROB             = 45; // 今日必抢

    private ActivityTypeConstant(){
    }

    /**
     * 
     * getTypeText:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param typeDuibaActivity
     * @return
     * @since JDK 1.6
     */
    public static String getTypeText(Integer typeDuibaActivity) {
        String text = "未知";
        if (typeDuibaActivity == null) {
            return text;
        }
        switch (typeDuibaActivity) {
            case TYPE_DUIBA_ACTIVITY:
                text = "专题活动";
                break;
            case TYPE_TURN_TABLE:
                text = "大转盘活动";
                break;
            case TYPE_DUIBA_SINGLE_LOTTERY:
                text = "兑吧单品抽奖";
                break;
            case TYPE_APP_SINGLE_LOTTERY:
                text = "APP自有单品抽奖";
                break;
            case TYPE_DUIBA_TURN_TABLE:
                text = "兑吧大转盘";
                break;
            case TYPE_APP_MANUAL_LOTTERY:
                text = "APP自有手动开奖";
                break;
            case TYPE_SHAKE_LOTTERY:
                text = "摇一摇";
                break;
            case TYPE_SCRATCH_CARD:
                text = "刮刮乐";
                break;
            case TYPE_HD_TOOL_TURN_TABLE:
                text = "大转盘";
                break;
            case TYPE_HD_TOOL_TIGER:
                text = "摇奖机";
                break;
            case TYPE_HD_TOOL_FLOP:
                text = "翻牌子";
                break;
            case TYPE_HD_TOOL_SMASHG:
                text = "砸彩蛋";
                break;
            case TYPE_SECONDS_KILL:
                text = "周三必抢";
                break;
            case TYPE_GAME_SANTA:
                text = "游戏活动-打劫圣诞老人";
                break;
            case TYPE_GAME_YEAR_AWARD:
                text = "游戏活动-数年终奖";
                break;
            case TYPE_GAME_GIRL:
                text = "游戏活动-女神PK";
                break;
            case TYPE_GAME_JIONG:
                text = "游戏活动-人在囧途";
                break;
            case TYPE_DUIBA_QUESTION_ANSWER:
                text = "兑吧答题";
                break;
            case TYPE_DUIBA_QUIZZ:
                text = "测试题";
                break;
            case TYPE_DUIBA_SEC_KILL:
                text = "兑吧秒杀活动";
                break;
            case TYPE_DUIBA_NGAME:
                text = "兑吧新游戏";
                break;
            case TYPE_DUIBA_GUESS:
                text = "兑吧竞猜";
                break;
            case TYPE_DUIBA_ROB:
                text = "今日必抢";
                break;
            default:
                break;
        }
        return text;
    }
}
