/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告位Dto <br/>
 * Date: 2016年9月26日 下午5:05:11 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class SlotDto extends BaseDto {

    private static final long  serialVersionUID                           = 8911023809144330642L;

    /** 广告位类型 0-插屏. */
    public static final int    ADSENSE_TYPE_PLAQUE                        = 0;
    /** 广告位类型 1-横幅. */
    public static final int    ADSENSE_TYPE_STREAMER_BANNER               = 1;
    /** 广告位类型 2-信息流. */
    public static final int    ADSENSE_TYPE_INFORMATION_STREAM            = 2;
    /** 广告位类型 3-banner. */
    public static final int    ADSENSE_TYPE_BANNER                        = 3;
    /** 广告位类型 4-浮标. */
    public static final int    ADSENSE_TYPE_BUOY                          = 4;
    /** 广告位类型 5-应用墙. */
    public static final int    ADSENSE_TYPE_APP_WALL                      = 5;
    /** 广告位类型 6-开屏. */
    public static final int    ADSENSE_TYPE_OPEN_SCREEN                   = 6;
    /** 广告位类型 7-自定义. */
    public static final int    ADSENSE_TYPE_USER_DEFINED                  = 7;
    /** 广告位类型 8-手动投放. */
    public static final int    ADSENSE_TYPE_MANUAL                        = 8;
    /** 广告位类型 9-非手动投放 */
    public static final int    ADSENSE_TYPE_MATERIAL_SPEC                 = 9;

    /** 广告位类型 0-插屏. */
    public static final String ADSENSE_TYPE_PLAQUE_STR                    = "插屏";
    /** 广告位类型 1-横幅. */
    public static final String ADSENSE_TYPE_STREAMER_BANNER_STR           = "横幅";
    /** 广告位类型 2-信息流. */
    public static final String ADSENSE_TYPE_INFORMATION_STREAM_STR        = "信息流";
    /** 广告位类型 3-banner. */
    public static final String ADSENSE_TYPE_BANNER_STR                    = "banner";
    /** 广告位类型 4-浮标. */
    public static final String ADSENSE_TYPE_BUOY_STR                      = "浮标";
    /** 广告位类型 5-应用墙. */
    public static final String ADSENSE_TYPE_APP_WALL_STR                  = "应用墙";
    /** 广告位类型 6-开屏. */
    public static final String ADSENSE_TYPE_OPEN_SCREEN_STR               = "开屏";
    /** 广告位类型 7-自定义. */
    public static final String ADSENSE_TYPE_USER_DEFINED_STR              = "自定义";
    /** 广告位类型 8-手动投放. */
    public static final String ADSENSE_TYPE_MANUAL_STR                    = "手动投放";
    /** 广告位类型 9-非手动投放 */
    public static final String ADSENSE_TYPE_MATERIAL_SPEC_STR             = "非手动投放";

    /** 开通状态:0-待审核. */
    public static final int    CHECK_STATUS_CHECKING                      = 0;
    /** 开通状态:1-审核通过. */
    public static final int    CHECK_STATUS_PASS                          = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int    CHECK_STATUS_FAIL                          = 2;

    /** 广告位状态:0-关闭. */
    public static final int    ENABLE_STATUS_CLOSE                        = 0;
    /** 广告位状态:1-开启. */
    public static final int    ENABLE_STATUS_OPEN                         = 1;

    /** 广告类型 -信息流-广告位尺寸 0-750*420 */
    public static final int    ADSENSE_TYPE_INFORMATION_FLOW_SIZE_750_420 = 0;
    /** 广告类型 -信息流-广告位尺寸 1-750*180 */
    public static final int    ADSENSE_TYPE_INFORMATION_FLOW_TYPE_750_180 = 1;

    /** 75：42 广告尺寸 */
    public static final String FLOW_TYPE_SIZE_750_420                     = "750*420";
    /** 25：6 广告尺寸 */
    public static final String FLOW_TYPE_SIZE_750_180                     = "750*180";

    /** 类型数量 */
    public static final int    ADSENSE_TYPE_SIZE                          = 9;

    /** 媒体ID. */
    private Long               appId;

    /** 媒体用户ID. */
    private Long               mediaId;

    /** 广告位名称. */
    private String             slotName;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer            slotType;

    /** 素材规格ID. */
    private Long               slotMsId;

    /** 审核状态:0-待审核;1-审核拒绝;2-审核通过. */
    private Integer            checkStatus;

    /** 广告位状态:0-关闭;1-开启. */
    private Integer            enableStatus;

    /** 主图尺寸 0-600*300 1-600*500 2-640*270 3-960*640 4-800*120. */
    private Integer            pictureSize;

    /** 屏蔽策略ID. */
    private Long               strategyId;

    /** 小图标是否可见. */
    private boolean            isVisibleOfIco;

    /** 关闭按钮是否可见. */
    private boolean            isVisibleOfCloseButton;

    /** 手动投放时的活动投放地址. */
    private String             activityUrl;

    /** 手动投放时的活动投放目标地址. */
    private String             activityTargetUrl;

    /** 广告位曝光上限 */
    private Integer            slotExposeLimit;

    /** 活动曝光上限 */
    private Integer            activityExposeLimit;

    public boolean isVisibleOfIco() {
        return isVisibleOfIco;
    }

    public void setVisibleOfIco(boolean isVisibleOfIco) {
        this.isVisibleOfIco = isVisibleOfIco;
    }

    public boolean isVisibleOfCloseButton() {
        return isVisibleOfCloseButton;
    }

    public void setVisibleOfCloseButton(boolean isVisibleOfCloseButton) {
        this.isVisibleOfCloseButton = isVisibleOfCloseButton;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getPictureSize() {
        return pictureSize;
    }

    public void setPictureSize(Integer pictureSize) {
        this.pictureSize = pictureSize;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getActivityTargetUrl() {
        return activityTargetUrl;
    }

    public void setActivityTargetUrl(String activityTargetUrl) {
        this.activityTargetUrl = activityTargetUrl;
    }

    public Integer getSlotExposeLimit() {
        return slotExposeLimit;
    }

    public void setSlotExposeLimit(Integer slotExposeLimit) {
        this.slotExposeLimit = slotExposeLimit;
    }

    public Integer getActivityExposeLimit() {
        return activityExposeLimit;
    }

    public void setActivityExposeLimit(Integer activityExposeLimit) {
        this.activityExposeLimit = activityExposeLimit;
    }

    public Long getSlotMsId() {
        return slotMsId;
    }

    public void setSlotMsId(Long slotMsId) {
        this.slotMsId = slotMsId;
    }

    /**
     * slotNumToName:(获取广告位类型名称通过广告类型编号). <br/>
     *
     * @param slotType
     * @return
     * @since JDK 1.6
     */
    public static String getSlotTypeNameBySlotType(int slotType) {
        String slotTypeName = "";
        switch (slotType) {
            case ADSENSE_TYPE_PLAQUE:
                slotTypeName = "插屏";
                break;
            case ADSENSE_TYPE_STREAMER_BANNER:
                slotTypeName = "横幅";
                break;
            case ADSENSE_TYPE_INFORMATION_STREAM:
                slotTypeName = "信息流";
                break;
            case ADSENSE_TYPE_BANNER:
                slotTypeName = "banner";
                break;
            case ADSENSE_TYPE_BUOY:
                slotTypeName = "浮标";
                break;
            case ADSENSE_TYPE_APP_WALL:
                slotTypeName = "应用墙";
                break;
            case ADSENSE_TYPE_OPEN_SCREEN:
                slotTypeName = "开屏";
                break;
            case ADSENSE_TYPE_USER_DEFINED:
                slotTypeName = "自定义";
                break;
            case ADSENSE_TYPE_MANUAL:
                slotTypeName = "手动投放";
                break;
            case ADSENSE_TYPE_MATERIAL_SPEC:
                slotTypeName = "非手动投放";
                break;
            default:
                break;
        }
        return slotTypeName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
