/**
 * Project Name:media-api<br>
 * File Name:SlotParam.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年11月1日上午11:44:53<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: SlotParam <br/>
 * Function: 广告参数. <br/>
 * date: 2016年11月1日 上午11:44:53 <br/>
 *
 * @author guyan
 * @version
 * @since JDK 1.6
 */
public class SlotTypeParamDto implements Serializable {

    /** 序列化ID */
    private static final long serialVersionUID = 8208167000275549043L;

    private List<String>      pictureSize;

    /** 广告信息流 */
    private List<String>      flowType;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private String            slotType;

    /** 广告位类型编码 */
    private Integer           typeCode;

    public List<String> getPictureSize() {
        return pictureSize;
    }

    public void setPictureSize(List<String> pictureSize) {
        this.pictureSize = pictureSize;
    }

    public String getSlotType() {
        return slotType;
    }

    public void setSlotType(String slotType) {
        this.slotType = slotType;
    }

    public List<String> getFlowType() {
        return flowType;
    }

    public void setFlowType(List<String> flowType) {
        this.flowType = flowType;
    }

    public Integer getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(Integer typeCode) {
        this.typeCode = typeCode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
