/**
 * Project Name:media-api File Name:RspDataStatistics.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月11日下午2:27:11 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspDataStatistics <br/>
 * Function: 结算数据统计. <br/>
 * Date: 2016年10月11日 下午2:27:11 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspSlotLineStatisticsDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 2902137581196740720L;

    /** 当前日期 */
    private List<String>      curDate;
    /** 点击数. */
    private List<Long>        clickCount;
    /** 曝光量. */
    private List<Long>        exposureCount;
    /** 每一千次的有效价格. */
    private List<Long>        eCpm;
    /** 预计收入. */
    private List<Long>        consumeTotal;
    /** 点击率 */
    private List<Long>        clickRate;

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public List<String> getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(List<String> curDate) {
        this.curDate = curDate;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public List<Long> getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(List<Long> clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public List<Long> getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(List<Long> exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * eCpm.
     *
     * @return the eCpm
     * @since JDK 1.6
     */
    public List<Long> geteCpm() {
        return eCpm;
    }

    /**
     * eCpm.
     *
     * @param eCpm the eCpm to set
     * @since JDK 1.6
     */
    public void seteCpm(List<Long> eCpm) {
        this.eCpm = eCpm;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public List<Long> getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(List<Long> consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * clickRate.
     *
     * @return the clickRate
     * @since JDK 1.6
     */
    public List<Long> getClickRate() {
        return clickRate;
    }

    /**
     * clickRate.
     *
     * @param clickRate the clickRate to set
     * @since JDK 1.6
     */
    public void setClickRate(List<Long> clickRate) {
        this.clickRate = clickRate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
