package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAdvertDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivityBackendService {

    /**
     * getByActivityIds:(查询活动接口). <br/>
     *
     * @author ZFZ
     * @param activityIds 查询条件
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds);

    /**
     * 给活动推荐使用的接口，根据活动id和Type查找活动,status=1，isDelete=0
     *
     * @param id 活动ID
     * @param type 活动类型
     * @return 活动名称
     */
    DubboResult<String> getActivityNameByIdAndType(Long id, Integer type);

    /**
     * 查询活动计划列表
     * 
     * @param req 查询条件
     * @return 活动计划列表
     */
    DubboResult<PageResultDto<RspActivityDto>> getPlanList(ReqActivityDto req);

    /**
     * 发布活动计划
     *
     * @param activities 活动：id+type
     * @return Boolean
     */
    DubboResult<Boolean> addActivityPlan(List<ReqIdAndType> activities);

    /**
     * 删除活动计划
     * 
     * @param activityId 活动ID
     * @param activityType 活动TYPE
     * @return Boolean
     */
    DubboResult<Boolean> deleteActivityPlan(Long activityId, Integer activityType);

    /**
     * 开启/关闭活动计划
     * 
     * @param activityId
     * @param activityType
     * @param enableStatus
     * @return Boolean
     */
    DubboResult<Boolean> changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus);

    /**
     * 编辑活动计划
     *
     * @param reqActivityDto
     * @return Boolean
     */
    DubboResult<Boolean> updateActivityPlan(ReqActivityDto reqActivityDto);

    /**
     * 获取活动计划明细
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 活动计划
     */
    DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer activityType);

    /**
     * 获取活动定向的媒体
     * 
     * @param activityId
     * @param activityType
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer activityType);

    /**
     * 活动媒体定向
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param directStatus 是否开启定向
     * @param appIds 媒体ID列表
     * @return Boolean
     */
    DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds);

    /**
     * 获取活动定制广告
     * 
     * @param activityId
     * @param activityType
     * @return
     */
    DubboResult<List<RspActivityAdvertDto>> getActivityDirectedAdvert(Long activityId, Integer activityType);

    /**
     * 活动定制广告
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param directStatus 是否开启定制
     * @param directMode 定向模式
     * @param advertIds 广告ID列表
     * @return Boolean
     */
    DubboResult<Boolean> activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> advertIds);

    /**
     * 编辑活动计划时查询所有规格列表
     * 
     * @return 规格列表
     */
    DubboResult<List<RspMaterialSpecificationDto>> getMsItemList();

    /**
     * 根据广告ID列表获取广告，有所有信息
     *
     * @param ids 广告ID列表
     * @return 广告列表
     */
    DubboResult<List<RspActivityAdvertDto>> getAdvertByIds(List<Long> ids);

    /**
     * 获取活动明细，只带基本信息，给引擎提供的接口
     *
     * @param activityId
     * @param activityType
     * @return 活动明细
     */
    DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer activityType);

    /**
     * 查询活动关联广告，给引擎提供的接口
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 广告ID列表
     */
    DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer activityType);
}
