package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2016/12/26
 */
public interface RemoteMaterialSpecificationBackendService {

    /**
     * 查询广告规格列表
     * 
     * @param req 查询条件
     * @return 广告规格列表
     */
    DubboResult<PageResultDto<RspMaterialSpecificationDto>> getMaterialSpecificationList(ReqMaterialSpecificationDto req);

    /**
     * 删除规格
     * 
     * @param id 规格ID
     * @return Boolean
     */
    DubboResult<Boolean> deleteMaterialSpecification(Long id);

    /**
     * 获取规格明细
     * 
     * @param msId 规格ID
     * @return 规格明细
     */
    DubboResult<RspMaterialSpecificationDto> getMaterialSpecificationDetail(Long msId);

    /**
     * 添加/更新规格
     * 
     * @param req 规格
     * @return Boolean
     */
    DubboResult<Boolean> addMaterialSpecification(ReqMaterialSpecificationDto req);

    /**
     * 规格定向
     * 
     * @param msId 规格ID
     * @param appIds 媒体ID列表
     * @param directStatus
     * @return Boolean
     */
    DubboResult<Boolean> msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus);

    /**
     * 获取规格定向的媒体列表
     * 
     * @param msId 规格ID
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getMsDirectedMediaApp(Long msId);

    /**
     * 通过ID列表获取规格名称列表
     * 
     * @param ids 规格ID列表
     * @return MAP
     */
    DubboResult<Map<Long, String>> getMsNameByIds(List<Long> ids);
}
