/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.api.client;

import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.StrategyCacheDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaService;
import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.redis.RedisClient;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TuiaMediaClient {
    protected static final int ONE_WEEK = 604800;
    protected static final long DEFAULT_ID = -1L;
    @Autowired
    protected RedisClient redisClient;
    @Autowired
    private RemoteMediaService remoteMediaService;

    public StrategyCacheDto getStrategyBySlotId(Long slotId) {
        SlotCacheDto slotCacheDto = this.getSlotBySlotId(slotId);
        if (slotCacheDto == null) {
            slotCacheDto = this.doUpdateSlot(slotId);
        }
        if (slotCacheDto.getId() == -1L || slotCacheDto.getStrategyId() == null) {
            return null;
        }
        return this.doGetStrategyBySlotId(slotCacheDto);
    }

    private StrategyCacheDto doGetStrategyBySlotId(SlotCacheDto slotCacheDto) {
        StrategyCacheDto strategyCacheDto;
        Long strategyId = slotCacheDto.getStrategyId();
        String strategy = this.redisClient.get(CacheKeyUtils.getStrategyKey(strategyId));
        if (StringUtils.isEmpty((String)strategy)) {
            DubboResult<StrategyCacheDto> dubboResult = this.remoteMediaService.updateStrategyById(strategyId);
            if (!dubboResult.isSuccess()) {
                return null;
            }
            strategyCacheDto = (StrategyCacheDto)dubboResult.getResult();
            if (strategyCacheDto == null) {
                this.redisClient.setex(CacheKeyUtils.getStrategyKey(strategyId), 604800, JSONObject.toJSONString((Object)new StrategyCacheDto(-1L)));
            }
        } else {
            strategyCacheDto = (StrategyCacheDto)JSONObject.parseObject((String)strategy, StrategyCacheDto.class);
            strategyCacheDto = strategyCacheDto.getId() != null && strategyCacheDto.getId() == -1L ? null : strategyCacheDto;
        }
        return strategyCacheDto;
    }

    public MediaAppDataDto getMediaAppByKey(String appKey) {
        String strMedaiAppData = this.redisClient.get(CacheKeyUtils.getMediaAppByKey(appKey));
        if (StringUtils.isNotBlank((String)strMedaiAppData)) {
            MediaAppDataDto mediaAppDataDto = (MediaAppDataDto)JSONObject.parseObject((String)strMedaiAppData, MediaAppDataDto.class);
            return mediaAppDataDto.getAppId() == -1L ? null : mediaAppDataDto;
        }
        DubboResult<MediaAppDataDto> dubboResult = this.remoteMediaService.updateMediaAppByKey(appKey);
        if (!dubboResult.isSuccess()) {
            return null;
        }
        MediaAppDataDto mediaAppDataDto = (MediaAppDataDto)dubboResult.getResult();
        if (mediaAppDataDto == null) {
            this.redisClient.setex(CacheKeyUtils.getMediaAppByKey(appKey), 604800, JSONObject.toJSONString((Object)new MediaAppDataDto(-1L)));
        }
        return mediaAppDataDto;
    }

    private SlotCacheDto getSlotBySlotId(Long slotId) {
        String strSlot = this.redisClient.get(CacheKeyUtils.getSlotKey(slotId));
        if (StringUtils.isBlank((String)strSlot)) {
            return null;
        }
        return (SlotCacheDto)JSONObject.parseObject((String)strSlot, SlotCacheDto.class);
    }

    public SlotCacheDto getSlotById(Long slotId) {
        SlotCacheDto slotCacheDto = this.getSlotBySlotId(slotId);
        if (slotCacheDto == null) {
            slotCacheDto = this.doUpdateSlot(slotId);
        } else if (-1L == slotCacheDto.getId()) {
            slotCacheDto = null;
        }
        return slotCacheDto;
    }

    private SlotCacheDto doUpdateSlot(Long slotId) {
        SlotCacheDto slotCacheDto = null;
        DubboResult<SlotCacheDto> dubboResult = this.remoteMediaService.updateSlot(slotId);
        if (dubboResult.isSuccess() && (slotCacheDto = (SlotCacheDto)dubboResult.getResult()) == null) {
            this.redisClient.setex(CacheKeyUtils.getSlotKey(slotId), 604800, JSONObject.toJSONString((Object)new SlotCacheDto(-1L)));
        }
        return slotCacheDto;
    }
}

