package cn.com.duiba.tuia.media.api.constant;

/**
 * @author xuyenan
 * @createTime 2017/1/6
 */
public class AdvertValidStatusConstant {

    /** 无效(兑吧广告)状态. */
    public static final int INVALID_DUIBA                    = 0;

    /** 有效状态. */
    public static final int VALID_STATUS                     = 1;

    /** 无效(暂停)状态. */
    public static final int INVALID_SUSPEND                  = 2;

    /** 无效(审核中)状态. */
    public static final int INVALID_CHECK_IN                 = 3;

    /** 无效(审核拒绝)状态. */
    public static final int INVALID_CHECK_REFUSE             = 4;

    /** 无效(账号余额不足)状态. */
    public static final int INVALID_BALANCE_NOT_ENOUGH       = 5;

    /** 无效(账号预算不足)状态. */
    public static final int INVALID_BALANCE_BUDGET_SHORTFALL = 6;

    /** 无效(广告预算不足)状态. */
    public static final int INVALID_ADVERT_BUDGET_SHORTFALL  = 7;

    /** 无效(库存不足)状态. */
    public static final int INVALID_INADEQUATE_INVENTORY     = 8;

    /** 无效(非投放日期)状态. */
    public static final int INVALID_NON_DELIVERY_DATE        = 9;

    /** 无效(优惠码失效)状态. */
    public static final int INVALID                          = 10;

    private AdvertValidStatusConstant(){
    }

    /**
     * 获取状态文案
     * 
     * @param status
     * @return 文案
     */
    public static String getValidStatusText(Integer status) {//NOSONAR
        String text = "未知状态";
        switch (status) {
            case INVALID_DUIBA:
                text = "无效";
                break;
            case VALID_STATUS:
                text = "有效";
                break;
            case INVALID_SUSPEND:
                text = "暂停";
                break;
            case INVALID_CHECK_IN:
                text = "审核中";
                break;
            case INVALID_CHECK_REFUSE:
                text = "审核拒绝";
                break;
            case INVALID_BALANCE_NOT_ENOUGH:
                text = "账号余额不足";
                break;
            case INVALID_BALANCE_BUDGET_SHORTFALL:
                text = "账号预算不足";
                break;
            case INVALID_ADVERT_BUDGET_SHORTFALL:
                text = "广告预算不足";
                break;
            case INVALID_INADEQUATE_INVENTORY:
                text = "库存不足";
                break;
            case INVALID_NON_DELIVERY_DATE:
                text = "非投放日期";
                break;
            case INVALID:
                text = "优惠码失效";
                break;
            default:
                break;
        }
        return text;
    }

}
