/**
 * 
 */
package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 此类描述的是：分页查询账户流水返回结果.
 *
 * @param <T> the generic type
 * @author: leiliang
 * @version: 2016年2月25日 下午3:06:54
 */
public class RspAccountChangeResult<T extends Serializable> implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 5759221006695554705L;

    /** 总数. */
    private int               totalCount;

    /** 总页数. */
    private int               totalPage;

    /** The data. */
    private List<T>           list;

    /** 当前账户余额 */
    private Long              balance;

    /**
     * Creates a new instance of RspAccountChangeResult.
     */
    public RspAccountChangeResult() {
        super();
    }

    /**
     * Creates a new instance of RspAccountChangeResult.
     *
     * @param totalAmount 总记录数
     * @param list 数据列表
     * @param pageSize 每页记录数
     * @param balance 当前账户余额
     */
    public RspAccountChangeResult(int totalAmount, List<T> list, int pageSize, Long balance) {
        super();
        this.totalCount = totalAmount;
        this.list = list;
        this.totalPage = setToalPage(pageSize);
        this.balance = balance;
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private int setToalPage(int pageSize) {
        if (totalCount < 0) {
            return 0;
        }

        return (totalCount % pageSize == 0) ? totalCount / pageSize : totalCount / pageSize + 1;
    }

    /**
     * accountBalance.
     *
     * @return the accountBalance
     * @since JDK 1.6
     */
    public Long getBalance() {
        return balance;
    }

    /**
     * accountBalance.
     *
     * @param accountBalance the accountBalance to set
     * @since JDK 1.6
     */
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    /**
     * Gets the total page.
     *
     * @return the total page
     */
    public int getTotalPage() {
        return totalPage;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @param totalCount the totalCount to set
     */
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    /**
     * @return the list
     */
    public List<T> getList() {
        return list;
    }

    /**
     * @param list the list to set
     */
    public void setList(List<T> list) {
        this.list = list;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
