package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.ActivityManualPlanDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 手动投放活动后台service
 */
public interface RemoteActivityManualBackendService {

    /**
     * @param manualPlan
     * @return
     */
    DubboResult<Boolean> addActivityManualPlan(ActivityManualPlanDto manualPlan);

    /**
     * @param slotId
     * @return
     */
    DubboResult<List<ActivityManualPlanDto>> findActivityManualPlans(Long slotId);

    /**
     * @param planDto
     * @return
     */
    DubboResult<Boolean> modifyActivityManualPlan(ActivityManualPlanDto planDto);

    /**
     * @param planDto
     * @return
     */
    DubboResult<Boolean> removeActivityManualPlan(ActivityManualPlanDto planDto);

    /**
     * @param activityId
     * @param activityType
     * @return
     */
    DubboResult<List<Long>> findActivityManualPlanSlot(Long activityId, Integer activityType);
}
