/**
 * Project Name:media-api<br>
 * File Name:RemoteStatisticstBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年10月10日下午4:18:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetActivityData;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityDetailData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotStatisticsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteStatisticstBackendService <br/>
 * date: 2016年10月10日 下午4:18:04 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface RemoteStatisticstBackendService {

    /**
     * 统计广告位数据.
     *
     * @param req the req
     * @return the adsense data
     */
    DubboResult<PageResultDto<RspSlotStatisticsDto>> getAdsenseData(ReqSlotStatisticsDto req);

    /**
     * 统计媒体数据.
     *
     * @param req the req
     * @return the media data
     */
    DubboResult<PageResultDto<RspMediaAppStatisticsDto>> getMediaData(ReqMediaAppStatisticsDto req);

    /**
     * 分页查询活动统计数据.
     *
     * @param req the req
     * @return the media data
     */
    DubboResult<PageResultDto<RspGetActivityData>> getActivityDataByPage(ReqGetActivityData req);

    /**
     * 查询活动统计数据列表.<br>
     * 最多10000行记录<br>
     *
     * @param req the req
     * @return the activity data list
     */
    DubboResult<List<RspGetActivityData>> getActivityDataList(ReqGetActivityData req);

    /**
     * 分页查询活动明细数据.
     *
     * @param req the req
     * @return the media data
     */
    DubboResult<PageResultDto<RspGetActivityDetailData>> getActivityDetailDataByPage(ReqGetActivityData req);

    /**
     * 查询活动明细数据列表.<br>
     * 最多10000行记录<br>
     * 
     * @param req the req
     * @return the activity detail data list
     */
    DubboResult<List<RspGetActivityDetailData>> getActivityDetailDataList(ReqGetActivityData req);
}
