package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivitySortBackendService {

    /**
     * getByCondition:(查询活动列表接口). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @since JDK 1.6
     */
    DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort);

    /**
     * addActivitySort:(添加活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param idAndTypes 活动列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes);

    /**
     * addDefaultActivitySort:(添加默认活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addDefaultActivitySort(Long slotId);

    /**
     * removeActivity:(移除活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeActivity(Long slotId, Long activityId, Integer activityType);

    /**
     * sort:(排序接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param activityType 位置
     * @param location
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> sort(Long slotId, Long activityId, Integer activityType, int location);

    /**
     * 给活动推荐引擎提供的查询媒体活动的接口
     *
     * @param appId 活动媒体ID
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityByApp(Long appId);

    /**
     * 给活动推荐引擎提供查询广告活动的接口
     *
     * @param slotId 广告位ID
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityBySlotNew(Long slotId);

    /**
     * 给活动中心的提供的接口
     * 
     * @param slotId 广告位ID
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityForCenter(Long slotId);

    /**
     * 给活动中心的提供的接口,获取推荐的活动ID列表
     * 
     * @param count 数量
     * @return
     */
    DubboResult<List<Long>> getActivityIdForCenter(int count);
    
    /**
     * 获取引擎投放列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getEngineActivityList();

    /**
     * 获取试投列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getNewActivityList();

    /**
     * 获取默认列表
     * 
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getDefaultActivityList();

    /**
     * 根据活动ID列表获取活动详情列表
     * 
     * @param ids 活动ID列表
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityPlanDetailList(List<Long> ids);
}
