/**
 * Project Name:media-api File Name:ReqCreatMediaAppDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月11日上午11:01:49 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

/**
 * ClassName:ReqCreatMediaAppDto <br/>
 * Function: 媒体app Dto. <br/>
 * Date: 2016年10月11日 上午11:01:49 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqCreatMediaAppDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID           = -4591723150503359954L;

    /** 开通状态:0-待审核. */
    public static final int   MEDIA_APP_CHECKING         = 0;
    /** 开通状态:1-审核通过. */
    public static final int   MEDIA_APP_CHECK_PASS       = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int   MEDIA_APP_CHECK_FAIL       = 2;

    /** 系统平台:1-Android. */
    public static final int   MEDIA_APP_PLATFORM_ANDROID = 1;
    /** 系统平台:2-iOS. */
    public static final int   MEDIA_APP_PLATFORM_IOS     = 2;
    /** 系统平台:3-H5. */
    public static final int   MEDIA_APP_PLATFORM_H5      = 3;

    /** 媒体用户ID */
    @ApiModelProperty(value = "媒体用户ID", required = false)
    private Long              mediaId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称", required = true)
    @NotNull(message = "媒体名称不能为空")
    private String            appName;

    /** 行业类别. */
    @ApiModelProperty(value = "行业类别", required = true)
    private String            industry;

    /** 系统平台:1-Android;2-iOS;3-H5. */
    @ApiModelProperty(value = "系统平台", required = true)
    @NotNull(message = "系统平台不能为空")
    private String            platform;

    /** 程序主包名. */
    @ApiModelProperty(value = "程序主包名", required = false)
    private String            appPackage;

    /** 媒体关键词. */
    @ApiModelProperty(value = "媒体关键词", required = false)
    private String            appKeyWords;

    /** 媒体简介. */
    @ApiModelProperty(value = "媒体简介", required = false)
    @Length(max = 100, message = "最大不能超过100个字符!")
    private String            description;

    /** 下载地址. */
    @ApiModelProperty(value = "下载地址", required = false)
    private String            downloadUrl;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppKeyWords() {
        return appKeyWords;
    }

    public void setAppKeyWords(String appKeyWords) {
        this.appKeyWords = appKeyWords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
