package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author songjiaxing
 * @createTime 2017/03/22
 */
public interface RemoteActivitySortService {

   
    /**
     * 给活动中心的提供的接口
     * 
     * @param slotId 广告位ID
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityForCenter(Long slotId);

    /**
     * 给活动中心的提供的接口,获取推荐的活动ID列表
     * 
     * @param count 数量
     * @return
     */
    DubboResult<List<Long>> getActivityIdForCenter(int count);

    /**
     * 给活动推荐引擎提供查询广告活动的接口
     *
     * @param slotId 广告位ID
     * @return 活动列表
     */
    public DubboResult<List<RspActivityDto>> getActivityBySlotNew(Long slotId);

    /**
     * 获取引擎投放列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getEngineActivityList();

    /**
     * 获取试投列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getNewActivityList();

    /**
     * 获取默认列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getDefaultActivityList();

    /**
     * 根据活动ID列表获取活动详情列表
     *
     * @param ids 活动ID列表
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityPlanDetailList(List<Long> ids);

    
   
}
