package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


public interface RemoteTuiaActivityService {

    /**
     * 获取活动定向的媒体
     *
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer source);

    /**
     * 获取活动明细，只带基本信息，给引擎提供的接口
     *
     * @param activityId
     * @param source 活动来源
     * @return 活动明细
     */
    DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer source);
    
    /**
     * 查询活动关联广告，给引擎提供的接口
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 广告ID列表
     */
    DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer source);

    /**
     * 查询某个活动在某个广告位下的SPM值
     *
     * @param slotId 广告位ID
     * @param statType 统计维度
     * @return 活动SPM
     */
    DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType);

    /**
     * 将活动从试投列表中移除
     *
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    DubboResult<Boolean> removeFromNewActList(Long activityId, Integer source);


}
