/**
 * Project Name:media-api<br>
 * File Name:SlotCacheDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月19日下午7:23:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: SlotCacheDto <br/>
 * Function: 屏蔽策略缓存对象. <br/>
 * date: 2016年10月19日 下午7:23:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class SlotCacheDto implements Serializable {

    private static final long  serialVersionUID    = 1L;

    /** 透明. */
    public static final String PICTURE_TYPE_ALPHA0 = "alpha0";

    private Long               id;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer            slotType;

    /** 主图尺寸-宽. */
    private int                pictureWidth;

    /** 主图尺寸-高. */
    private int                pictureHeight;

    /** 屏蔽策略ID. */
    private Long               strategyId;

    /** 是否有效：true：有效， false：无效(广告位审核中或者未开启). */
    private boolean            isValid;

    /** 图片类型 alpha0 透明 : */
    private String             pictureType;

    public SlotCacheDto() {
        super();
    }

    /**
     * Creates a new instance of SlotCacheDto.
     *
     * @param id
     */
    
    public SlotCacheDto(Long id) {
        super();
        this.id = id;
    }

    public SlotCacheDto(Long id, Integer slotType, int width, int height, Long strategyId, String pictureType) {
        super();
        this.id = id;
        this.slotType = slotType;
        this.pictureWidth = width;
        this.pictureHeight = height;
        this.strategyId = strategyId;
        this.pictureType = pictureType;
    }

    /**
     * pictureType.
     *
     * @return the pictureType
     * @since JDK 1.6
     */
    public String getPictureType() {
        return pictureType;
    }

    /**
     * pictureType.
     *
     * @param pictureType the pictureType to set
     * @since JDK 1.6
     */
    public void setPictureType(String pictureType) {
        this.pictureType = pictureType;
    }

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    public int getPictureWidth() {
        return pictureWidth;
    }

    public void setPictureWidth(int pictureWidth) {
        this.pictureWidth = pictureWidth;
    }

    public int getPictureHeight() {
        return pictureHeight;
    }

    public void setPictureHeight(int pictureHeight) {
        this.pictureHeight = pictureHeight;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
