package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivityAppBackendService {

    /**
     * 查询媒体接口
     *
     * @param reqActivityApp 查询条件
     */
    DubboResult<PageResultDto<RspActivityAppDto>> getActivityAppByPage(ReqActivityApp reqActivityApp);

    /**
     * 添加媒体接口
     *
     * @param activityAppIds 活动媒体ID列表
     */
    DubboResult<Boolean> addActivityApp(List<Long> activityAppIds);

    /**
     * 移除媒体
     *
     * @param activityAppId 需要移除的媒体ID
     */
    DubboResult<Boolean> removeActivityApp(Long activityAppId);

    /**
     * 添加定制媒体时的搜索接口
     * 
     * @param reqActivityApp 查询条件
     */
    DubboResult<List<RspActivityAppDto>> searchActivityApp(ReqActivityApp reqActivityApp);
}
