/**
 * Project Name:media-biz<br>
 * File Name:CacheKeyUtils.java<br>
 * Package Name:cn.com.duiba.tuia.media.utils<br>
 * Date:2016年9月26日下午4:59:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.utils;

import cn.com.duiba.tuia.media.api.constant.CacheKey;


/**
 * ClassName: CacheKeyUtils <br/>
 * Function: 获取缓存标志. <br/>
 * date: 2016年9月26日 下午4:59:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class CacheKeyUtils {

    /** The prefix. */
    private static String prefix;

    /**
     * Gets the prefix.
     *
     * @return the prefix
     */
    public static String getPrefix() {
        return prefix;
    }

    /**
     * Sets the prefix.
     *
     * @param prefix the prefix
     */
    public static void setPrefix(String prefix) {
        CacheKeyUtils.prefix = prefix;
    }

    /**
     * 获取短信缓存标志.
     *
     * @param phone 手机号
     * @param type 类型
     * @return the sms key
     */
    public static String getSmsKey(String phone, int type) {
        return getPrefix() + CacheKey.SMS_KEY + phone + "-" + type;
    }

    /**
     * 获取邮件验证码标识.
     *
     * @param userEmail 邮箱
     * @return the email key
     */
    public static String getResetPwEmailKey(String userEmail) {
        return getPrefix() + CacheKey.RESETPD_EMAIL_KEY + userEmail;
    }

    /**
     * 获取更好邮箱的邮件验证码标识.
     *
     * @param userId the user id
     * @param token the token
     * @return the email key
     */
    public static String getReplaceEmailKey(Long userId, String token) {
        return getPrefix() + CacheKey.REPLACE_EMAIL_KEY + userId + '-' + token;
    }

    /**
     * 获取屏蔽策略缓存标识.
     *
     * @param strategyId 屏蔽策略ID
     * @return the strategy key
     */
    public static String getStrategyKey(long strategyId) {
        return getPrefix() + CacheKey.STRATEGY_KEY + strategyId;
    }

    /**
     * 获取媒体用户状态缓存标识.
     *
     * @param mediaId 媒体ID
     * @return the media status key
     */
    public static String getMediaStatusKey(long mediaId) {
        return getPrefix() + CacheKey.MEDIA_STATUS_KEY + mediaId;
    }

    /**
     * 获取媒体应用缓存标识.
     *
     * @param slotId the slot id
     * @return the media app strategy key
     */
    public static String getSlotKey(long slotId) {
        return getPrefix() + CacheKey.SLOT_KEY + slotId;
    }

    /**
     * 获取媒体应用缓存标识.
     *
     * @param mediaAppId 媒体应用ID
     * @return the media app key
     */
    public static String getMediaAppKey(long mediaAppId) {
        return getPrefix() + CacheKey.MEDIA_APP_KEY + mediaAppId;
    }

    /**
     * 获取媒体应用缓存标识.
     *
     * @param appKey app key
     * @return the media app key
     */
    public static String getMediaAppByKey(String appKey) {
        return getPrefix() + CacheKey.MEDIA_APP_BY_KEY + appKey;
    }

}
