/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.api.client;

import cn.com.duiba.tuia.media.api.constant.RedisKeyConstant;
import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.StrategyCacheDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public class TuiaMediaClient {
    private static final int ONE_WEEK = 7;
    protected static final long DEFAULT_ID = -1L;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private RemoteMediaService remoteMediaService;

    public StrategyCacheDto getStrategyBySlotId(Long slotId) {
        SlotCacheDto slotCacheDto = this.getSlotBySlotId(slotId);
        if (slotCacheDto == null) {
            slotCacheDto = this.doUpdateSlot(slotId);
        }
        if (null == slotCacheDto || slotCacheDto.getId() == -1L || slotCacheDto.getStrategyId() == null) {
            return null;
        }
        StrategyCacheDto dto = this.doGetStrategyBySlotId(slotCacheDto);
        if (dto != null) {
            dto.setAppId(null != slotCacheDto ? slotCacheDto.getAppId() : null);
            dto.setSlotId(slotId);
        }
        return dto;
    }

    private StrategyCacheDto doGetStrategyBySlotId(SlotCacheDto slotCacheDto) {
        StrategyCacheDto strategyCacheDto;
        Long strategyId = slotCacheDto.getStrategyId();
        String strategy = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKeyConstant.getStrategyKey(strategyId));
        if (StringUtils.isEmpty((String)strategy)) {
            DubboResult<StrategyCacheDto> dubboResult = this.remoteMediaService.updateStrategyById(strategyId);
            if (!dubboResult.isSuccess()) {
                return null;
            }
            strategyCacheDto = (StrategyCacheDto)dubboResult.getResult();
            if (strategyCacheDto == null) {
                this.stringRedisTemplate.opsForValue().set((Object)RedisKeyConstant.getStrategyKey(strategyId), (Object)JSONObject.toJSONString((Object)new StrategyCacheDto(-1L)), 7L, TimeUnit.DAYS);
            }
        } else {
            strategyCacheDto = (StrategyCacheDto)JSONObject.parseObject((String)strategy, StrategyCacheDto.class);
            strategyCacheDto = strategyCacheDto.getId() != null && strategyCacheDto.getId() == -1L ? null : strategyCacheDto;
        }
        return strategyCacheDto;
    }

    public MediaAppDataDto getMediaAppByKey(String appKey) {
        String strMedaiAppData = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKeyConstant.getMediaAppByKey(appKey));
        if (StringUtils.isNotBlank((String)strMedaiAppData)) {
            MediaAppDataDto mediaAppDataDto = (MediaAppDataDto)JSONObject.parseObject((String)strMedaiAppData, MediaAppDataDto.class);
            return mediaAppDataDto.getAppId() == -1L ? null : mediaAppDataDto;
        }
        DubboResult<MediaAppDataDto> dubboResult = this.remoteMediaService.updateMediaAppByKey(appKey);
        if (!dubboResult.isSuccess()) {
            return null;
        }
        MediaAppDataDto mediaAppDataDto = (MediaAppDataDto)dubboResult.getResult();
        if (mediaAppDataDto == null) {
            this.stringRedisTemplate.opsForValue().set((Object)RedisKeyConstant.getMediaAppByKey(appKey), (Object)JSONObject.toJSONString((Object)new MediaAppDataDto(-1L)), 7L, TimeUnit.DAYS);
        }
        return mediaAppDataDto;
    }

    private SlotCacheDto getSlotBySlotId(Long slotId) {
        String strSlot = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKeyConstant.getSlotKey(slotId));
        if (StringUtils.isBlank((String)strSlot)) {
            return null;
        }
        return (SlotCacheDto)JSONObject.parseObject((String)strSlot, SlotCacheDto.class);
    }

    public SlotCacheDto getSlotById(Long slotId) {
        SlotCacheDto slotCacheDto = this.getSlotBySlotId(slotId);
        if (slotCacheDto == null) {
            slotCacheDto = this.doUpdateSlot(slotId);
        } else if (-1L == slotCacheDto.getId()) {
            slotCacheDto = null;
        }
        return slotCacheDto;
    }

    private SlotCacheDto doUpdateSlot(Long slotId) {
        SlotCacheDto slotCacheDto = null;
        DubboResult<SlotCacheDto> dubboResult = this.remoteMediaService.updateSlot(slotId);
        if (dubboResult.isSuccess() && (slotCacheDto = (SlotCacheDto)dubboResult.getResult()) == null) {
            this.stringRedisTemplate.opsForValue().set((Object)RedisKeyConstant.getSlotKey(slotId), (Object)JSONObject.toJSONString((Object)new SlotCacheDto(-1L)), 7L, TimeUnit.DAYS);
        }
        return slotCacheDto;
    }
}

