/**
 * Project Name:media-api<br>
 * File Name:SlotCacheDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月19日下午7:23:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: SlotCacheDto <br/>
 * Function: 屏蔽策略缓存对象. <br/>
 * date: 2016年10月19日 下午7:23:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class SlotCfgCacheDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 424111602033441876L;

    private Long               id;

    /** 是否拦截返回操作(1:拦截，0:不拦截). */
    private Boolean            isReturn;

    /** 拦截返回操作频次. */
    private Integer            numReturn;

    /** 媒体APPID */
    private Long               appId;
    
    /** 推荐位弹层开关(1:开，0:关). */
    private Boolean            isRecommend;

    /**
     * Creates a new instance of SlotCacheDto.
     */
    public SlotCfgCacheDto() {
        super();
    }


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    
    public Long getId() {
        return id;
    }


    
    public void setId(Long id) {
        this.id = id;
    }


    
    public Boolean getIsReturn() {
        return isReturn;
    }


    
    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }


    
    public Integer getNumReturn() {
        return numReturn;
    }


    
    public void setNumReturn(Integer numReturn) {
        this.numReturn = numReturn;
    }


    
    public Boolean getIsRecommend() {
        return isRecommend;
    }


    
    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

}
