/**
 * Project Name:media-api<br>
 * File Name:ShieldStrategyBaseDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年9月29日下午3:19:22<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ShieldStrategyBaseDto <br/>
 * Function: 屏蔽策略信息. <br/>
 * date: 2016年9月29日 下午3:19:22 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class StrategyCacheDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 屏蔽策略ID. */
    private Long              id;

    /** 屏蔽行业列表，中间以逗号隔开. */
    private List<String>      shieldIndustries;

    /** 屏蔽广告列表，中间以逗号隔开. */
    private List<String>      advertTagNums;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    private List<String>      shieldUrls;
    
    /** 媒体appId. */
    private Long              appId;

    /** 广告位Id */
    private Long              slotId;

    /**
     * 
     * Creates a new instance of StrategyCacheDto.
     *
     */
    public StrategyCacheDto() {
        super();
    }

    /**
     * 
     * Creates a new instance of StrategyCacheDto.
     *
     * @param shieldIndustries
     * @param advertTagNums
     * @param shieldUrls
     */
    public StrategyCacheDto(List<String> shieldIndustries, List<String> advertTagNums, List<String> shieldUrls) {
        super();
        this.shieldIndustries = shieldIndustries;
        this.advertTagNums = advertTagNums;
        this.shieldUrls = shieldUrls;
    }

   
    /**
     * 
     * Creates a new instance of StrategyCacheDto.
     *
     * @param id
     * @param shieldIndustries
     * @param advertTagNums
     * @param shieldUrls
     */
    public StrategyCacheDto(Long id, List<String> shieldIndustries, List<String> advertTagNums, List<String> shieldUrls) {
        super();
        this.id = id;
        this.shieldIndustries = shieldIndustries;
        this.advertTagNums = advertTagNums;
        this.shieldUrls = shieldUrls;
    }

    /**
     * 
     * Creates a new instance of StrategyCacheDto.
     *
     * @param id
     */
    public StrategyCacheDto(Long id) {
        super();
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    public List<String> getAdvertTagNums() {
        return advertTagNums;
    }

    public void setAdvertTagNums(List<String> advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    public List<String> getShieldUrls() {
        return shieldUrls;
    }

    public void setShieldUrls(List<String> shieldUrls) {
        this.shieldUrls = shieldUrls;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    
    public Long getAppId() {
        return appId;
    }

    
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    
    public Long getSlotId() {
        return slotId;
    }

    
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

}
