/**
 * Project Name:media-api<br>
 * File Name:ReqSlotStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.req<br>
 * Date:2016年10月10日下午2:17:13<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.dto.req;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.media.api.dto.BaseDateQueryDto;

/**
 * ClassName: ReqSlotStatistics <br/>
 * date: 2016年10月10日 下午2:17:13 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqSlotStatisticsDto extends BaseDateQueryDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 7909666207420011262L;

    @ApiModelProperty(value = "广告位ID", required = false)
    private Long              slotId;

    @ApiModelProperty(value = "广告位名称", required = false)
    private String            slotName;

    @ApiModelProperty(value = "广告位类型", required = false)
    private Integer           slotType;

    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    @ApiModelProperty(value = "媒体账户ID", required = false)
    private Long              mediaId;
    
    /** 广告位id列表 */
	private List<Long>         slotIds;
	
	/** app_id列表 */
	private List<Long>         appIds;

    public List<Long> getAppIds() {
		return appIds;
	}

	public void setAppIds(List<Long> appIds) {
		this.appIds = appIds;
	}

	/**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
    public List<Long> getSlotIds() {
  		return slotIds;
  	}

  	public void setSlotIds(List<Long> slotIds) {
  		this.slotIds = slotIds;
  	}

}
