/**
 * Project Name:media-api File Name:RspMediaAppDataStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月13日下午8:23:36 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspMediaAppDataStatisticsDto <br/>
 * Function: 媒体app Dto. <br/>
 * Date: 2016年10月13日 下午8:23:36 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspMediaAppDataStatisticsDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -8689525577343654007L;

    /** 媒体ID. */
    private Long              appId;

    /** 媒体名称. */
    private String            appName;

    /** 媒体平台类型. */
    private String            platform;

    /** 曝光量. */
    private Long              exposureCount;

    /** 点击数. */
    private Long              clickCount;

    /** 点击率 */
    private Float             clickRate;

    /** 预计收入. */
    private Long              consumeTotal;

    /** 每一千次的有效价格. */
    private Long              eCpm;

    /** 点击单价. */
    private Long              cpc;

    /** 广告位成功响应数量 */
    private Long              actSucResponseCount;
    /**
     * geteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long geteCpm() {
        return eCpm;
    }

    /**
     * seteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param eCpm
     * @since JDK 1.6
     */
    public void seteCpm(Long eCpm) {
        this.eCpm = eCpm;
    }

    public Long getCpc() {
        return cpc;
    }

    public void setCpc(Long cpc) {
        this.cpc = cpc;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * platform.
     *
     * @return the platform
     * @since JDK 1.6
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * platform.
     *
     * @param platform the platform to set
     * @since JDK 1.6
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public Float getClickRate() {
        return clickRate;
    }

    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    public Long getActSucResponseCount() {
        return actSucResponseCount;
    }

    public void setActSucResponseCount(Long actSucResponseCount) {
        this.actSucResponseCount = actSucResponseCount;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
