/**
 * Project Name:media-api<br>
 * File Name:RemoteMediaBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年10月10日上午9:34:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountBaseDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteMediaBackendService <br/>
 * date: 2016年10月10日 上午9:34:24 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface RemoteMediaBackendService {

    /**
     * 分页查询媒体账户数据.
     *
     * @param req the req
     * @return the medias by page
     */
    DubboResult<PageResultDto<RspAccountBaseDto>> getMediasByPage(ReqGetAccountByPageDto req);

    /**
     * 查询媒体账户信息.
     *
     * @param mediaId the media id
     * @return the media by media id
     */
    DubboResult<AccountDto> getMediaByMediaId(long mediaId);

    /**
     * 更新冻结审核状态.
     *
     * @param mediaId the media id
     * @param checkType the check type
     * @param reason the reason
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateFreezeStatus(long mediaId, int checkType, String reason);

    /**
     * selectAccountByEmail:(通过email查询媒体用户信息). <br/>
     *
     * @param email
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountDto> selectAccountByEmail(String email);

    /**
     * selectAccountByIds:(通过媒体用户id集合查询用户信息). <br/>
     *
     * @param mediaIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountDto>> selectAccountByIds(List<Long> mediaIds);

    /**
     * selectAccountCacheById:(通过用户ID从缓存查询用户信息). <br/>
     *
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountDto> selectAccountCacheById(Long mediaId);
}
