/**
 * Project Name:media-biz<br>
 * File Name:CacheKeyUtils.java<br>
 * Package Name:cn.com.duiba.tuia.media.utils<br>
 * Date:2016年9月26日下午4:59:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.utils;

import cn.com.duiba.tuia.media.api.constant.CacheKey;
import cn.com.duiba.tuia.media.api.constant.SplitConstant;

/**
 * ClassName: CacheKeyUtils <br/>
 * Function: 获取缓存标志. <br/>
 * date: 2016年9月26日 下午4:59:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class CacheKeyUtils {

    /** The prefix. */
    private static String prefix;

    private CacheKeyUtils cu;

    public CacheKeyUtils getCacheKeyUtils() {
        if (cu == null) {
            cu = new CacheKeyUtils();
        }
        return cu;
    }

    /**
     * Gets the prefix.
     *
     * @return the prefix
     */
    public static String getPrefix() {
        return prefix;
    }

    /**
     * Sets the prefix.
     *
     * @param prefix the prefix
     */
    public static void setPrefix(String prefix) {
        CacheKeyUtils.prefix = prefix;
    }
    
    /**
     * 获取活动缓存标识.
     *
     * @param activityKey activity key
     * @return the activity key
     */
    public static String getActivityByKey(String activityKey) {
        return getPrefix() + CacheKey.ACTIVITY_KEY + activityKey;
    }

    /**
     * 获取活动定制广告缓存标识
     *
     * @param activityId
     * @param activityType
     * @return the activityAdvertKey
     */
    public static String getActivityAdvertByKey(Long activityId, Integer activityType) {
        return getPrefix() + CacheKey.ACTIVITY_ADVERT_KEY + activityId + SplitConstant.SPLIT_HYPHEN + activityType;
    }
    
    /**
     * 获取活动定制广告缓存标识
     *
     * @param activityId
     * @param source
     * @return the activityAdvertKey
     */
    public static String getActivityAdvertByKeyAndSource(Long activityId, Integer source) {
        return getPrefix() + CacheKey.ACTIVITY_SOURCE_ADVERT_KEY + activityId + SplitConstant.SPLIT_HYPHEN + source;
    }

}
