/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMaterialSpecificationBackendService;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.MediaAppMsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteMaterialSpecificationBackendServiceImpl
extends BaseRemoteService
implements RemoteMaterialSpecificationBackendService {
    @Autowired
    private MaterialSpecificationService materialSpecificationService;
    @Autowired
    private MediaAppMsService mediaAppMsService;

    public DubboResult<PageResultDto<RspMaterialSpecificationDto>> getMaterialSpecificationList(ReqMaterialSpecificationDto req) {
        try {
            return DubboResult.successResult((Object)new PageResultDto(this.materialSpecificationService.getMaterialSpecificationAmount(req), this.materialSpecificationService.getMaterialSpecificationList(req), req.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.getMaterialSpecificationList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> deleteMaterialSpecification(Long id) {
        try {
            return DubboResult.successResult((Object)this.materialSpecificationService.deleteMaterialSpecification(id));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.deleteMaterialSpecification is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspMaterialSpecificationDto> getMaterialSpecificationDetail(Long msId) {
        try {
            return DubboResult.successResult((Object)this.materialSpecificationService.getMaterialSpecificationDetail(msId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.getMaterialSpecificationDetail is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addMaterialSpecification(ReqMaterialSpecificationDto req) {
        try {
            return DubboResult.successResult((Object)this.materialSpecificationService.addMaterialSpecification(req));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.addMaterialSpecification is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus) {
        try {
            return DubboResult.successResult((Object)this.mediaAppMsService.MsDirectToMediaApp(msId, appIds, directStatus));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.msDirectToMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

