/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.constant.MaterialSpecificationConstant;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationItemDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemDO;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="materialSpecificationService")
public class MaterialSpecificationServiceImpl
implements MaterialSpecificationService {
    @Autowired
    private MaterialSpecificationDAO materialSpecificationDAO;
    @Autowired
    private MaterialSpecificationItemDAO materialSpecificationItemDAO;

    @Override
    public List<RspMaterialSpecificationDto> getMaterialSpecificationList(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        req.setSort("gmt_modified");
        req.setOrder("desc");
        List<MaterialSpecificationDO> list = this.materialSpecificationDAO.getList(req);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<RspMaterialSpecificationDto> result = new ArrayList<RspMaterialSpecificationDto>(list.size());
        for (MaterialSpecificationDO materialSpecificationDO : list) {
            RspMaterialSpecificationDto rspMaterialSpecificationDto = new RspMaterialSpecificationDto();
            BeanUtils.copyProperties((Object)materialSpecificationDO, (Object)rspMaterialSpecificationDto);
            result.add(rspMaterialSpecificationDto);
        }
        return result;
    }

    @Override
    public int getMaterialSpecificationAmount(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        return this.materialSpecificationDAO.getAmount(req);
    }

    @Override
    public Boolean deleteMaterialSpecification(Long msId) throws TuiaMediaException {
        return this.materialSpecificationDAO.delete(msId) == 1;
    }

    @Override
    @Transactional
    public Boolean addMaterialSpecification(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        MaterialSpecificationDO materialSpecificationDO = new MaterialSpecificationDO();
        materialSpecificationDO.setTitle(req.getTitle());
        materialSpecificationDO.setDescription(req.getDescription());
        materialSpecificationDO.setSchematicImg(req.getSchematicImg());
        if (req.getId() == null) {
            materialSpecificationDO.setIsDirect(MaterialSpecificationConstant.MS_NOT_DIRECT);
            this.materialSpecificationDAO.insert(materialSpecificationDO);
            for (RspMaterialSpecificationItemDto rspMsItem : req.getItemDtoList()) {
                rspMsItem.setMsId(materialSpecificationDO.getId());
            }
        } else {
            materialSpecificationDO.setId(req.getId());
            this.materialSpecificationDAO.update(materialSpecificationDO);
        }
        List msItemList = req.getItemDtoList();
        if (!CollectionUtils.isEmpty((Collection)msItemList)) {
            ArrayList<MaterialSpecificationItemDO> list = new ArrayList<MaterialSpecificationItemDO>(msItemList.size());
            for (RspMaterialSpecificationItemDto msItem : msItemList) {
                MaterialSpecificationItemDO materialSpecificationItemDO = new MaterialSpecificationItemDO();
                BeanUtils.copyProperties((Object)msItem, (Object)materialSpecificationItemDO);
                list.add(materialSpecificationItemDO);
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.materialSpecificationItemDAO.insertBatch(list);
            }
        }
        return true;
    }

    @Override
    public RspMaterialSpecificationDto getMaterialSpecificationDetail(Long msId) throws TuiaMediaException {
        MaterialSpecificationDO materialSpecificationDO = this.materialSpecificationDAO.getById(msId);
        if (materialSpecificationDO == null) {
            throw new TuiaMediaException(ErrorCode.E0501003);
        }
        RspMaterialSpecificationDto result = new RspMaterialSpecificationDto();
        result.setId(materialSpecificationDO.getId());
        result.setTitle(materialSpecificationDO.getTitle());
        result.setDescription(materialSpecificationDO.getDescription());
        result.setSchematicImg(materialSpecificationDO.getSchematicImg());
        List<MaterialSpecificationItemDO> msItemList = this.materialSpecificationItemDAO.getByMsId(materialSpecificationDO.getId());
        if (!CollectionUtils.isEmpty(msItemList)) {
            ArrayList<RspMaterialSpecificationItemDto> rspMsItemList = new ArrayList<RspMaterialSpecificationItemDto>(msItemList.size());
            for (MaterialSpecificationItemDO msItem : msItemList) {
                RspMaterialSpecificationItemDto rspMsItem = new RspMaterialSpecificationItemDto();
                BeanUtils.copyProperties((Object)msItem, (Object)rspMsItem);
                rspMsItemList.add(rspMsItem);
            }
            result.setItemDtoList(rspMsItemList);
        }
        return result;
    }
}

