/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.constant.MaterialSpecificationConstant;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationDAO;
import cn.com.duiba.tuia.media.dao.MediaAppMsDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;
import cn.com.duiba.tuia.media.dataobject.MediaAppMsDO;
import cn.com.duiba.tuia.media.service.MediaAppMsService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="mediaAppMsService")
public class MediaAppMsServiceImpl
implements MediaAppMsService {
    @Autowired
    private MediaAppMsDAO mediaAppMsDAO;
    @Autowired
    private MaterialSpecificationDAO materialSpecificationDAO;

    @Override
    @Transactional
    public Boolean MsDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus) throws TuiaMediaException {
        if (MaterialSpecificationConstant.MS_DIRECT != directStatus && MaterialSpecificationConstant.MS_NOT_DIRECT != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        MaterialSpecificationDO materialSpecificationDO = new MaterialSpecificationDO();
        materialSpecificationDO.setId(msId);
        materialSpecificationDO.setIsDirect(directStatus);
        this.materialSpecificationDAO.update(materialSpecificationDO);
        this.mediaAppMsDAO.delete(msId);
        if (!CollectionUtils.isEmpty(appIds)) {
            ArrayList<MediaAppMsDO> list = new ArrayList<MediaAppMsDO>(appIds.size());
            for (Long appId : appIds) {
                MediaAppMsDO mediaAppMsDO = new MediaAppMsDO();
                mediaAppMsDO.setMsId(msId);
                mediaAppMsDO.setMediaAppId(appId);
                list.add(mediaAppMsDO);
            }
            this.mediaAppMsDAO.insertBatch(list);
        }
        return true;
    }
}

