/**
 * Project Name:media-biz<br>
 * File Name:SlotBo.java<br>
 * Package Name:cn.com.duiba.tuia.media.bo<br>
 * Date:2016年9月30日下午3:05:18<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.bo;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.SlotTypeParamDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotBackendDetailDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: SlotBo <br/>
 * Function: 广告位业务编排层. <br/>
 * date: 2016年9月30日 下午3:05:18 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface SlotBackendBo {

    /**
     * 广告位批量审核.
     *
     * @param slotIds the slot ids
     * @param checkType the check type
     * @return the dubbo result< boolean>
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean batchUpdateCheckStatus(List<Long> slotIds, Integer checkType) throws TuiaMediaException;

    /**
     * 查询广告详情.
     *
     * @param slotId the slot id
     * @return the slot detail by id
     * @throws TuiaMediaException the tuia media exception
     */
    RspSlotDetailDto getSlotDetailById(Long slotId) throws TuiaMediaException;

    /**
     * 更新广告位.
     *
     * @param req the req
     * @return true, if update slot strategy
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean updateSlotStrategy(ReqUpdateSlotStrategy req) throws TuiaMediaException;

    /**
     * 查询广告位详情(后端). <br/>
     *
     * @author guyan
     * @param slotId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    RspSlotBackendDetailDto getBackendSlotDetailById(Long slotId) throws TuiaMediaException;
    
    /**
     * 
     * buildSoltTypeParam:构建广告选择类型参数. <br/>
     *
     * @author guyan
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<SlotTypeParamDto> buildSoltTypeParam()throws TuiaMediaException;

}
