package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;

import java.util.List;

/**
 * Function: ActivitySortDAO
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivitySortDAO {

    /**
     * insertBatch:(新增). <br/>
     *
     * @author ZFZ
     * @param activitySortDtoList
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException;

    /**
     * selectByCondition:(根据条件查询 ). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * select
     * 
     * @param slotId
     * @param activityId
     * @param activityType
     * @return
     * @throws TuiaMediaException
     */
    ActivitySortDto select(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException;

    /**
     * selectByConditionAmount:(根据条件查询时的数量). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * deleteAllSlotActivity:(移除某个广告位下的所有活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int deleteAllSlotActivity(Long slotId) throws TuiaMediaException;

    /**
     * deleteActivity:(移除所有slot下的某一个活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @param activityId
     * @param activityType
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int deleteActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException;

    /**
     * @param slotId
     * @param sort
     * @return
     * @throws TuiaMediaException
     */
    int selectSortLocation(Long slotId, Long sort) throws TuiaMediaException;

    /**
     * @param slotId
     * @param activityId
     * @param activityType
     * @param sort
     * @return
     * @throws TuiaMediaException
     */
    int updateSort(Long slotId, Long activityId, Integer activityType, Long sort) throws TuiaMediaException;

    /**
     * @param slotId
     * @param startSort
     * @param step
     * @return
     * @throws TuiaMediaException
     */
    int updateSortBatch(Long slotId, Long startSort, Long step) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：查询所有有效活动
     * 
     * @param appId
     * @return
     * @throws TuiaMediaException
     */
    List<ActivitySortDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：查询所有有效活动
     * 
     * @param slotId
     * @return
     * @throws TuiaMediaException
     */
    List<ActivitySortDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException;
}
