package cn.com.duiba.tuia.media.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityManualPlanDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;

@Repository("activityManualPlanDAO")
public class ActivityManualPlanDAOImpl extends BaseDAO implements ActivityManualPlanDAO {

    @Override
    public boolean insert(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insert"), manualPlan) > 0;
        } catch (Exception e) {
            logger.error("ActivityManualPlanDAOImpl.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityManualPlanDO> selectForList(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectForList"), slotId);
        } catch (Exception e) {
            logger.error("ActivityManualPlanDAOImpl.selectForList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public boolean update(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), manualPlan) > 0;
        } catch (Exception e) {
            logger.error("ActivityManualPlanDAOImpl.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public boolean updateStatus(ActivityManualPlanDO manualPlan, int status) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", manualPlan.getSlotId());
            map.put("activityId", manualPlan.getActivityId());
            map.put("activityType", manualPlan.getActivityType());
            map.put("status", status);
            return getSqlSession().update(getStamentNameSpace("updateStatus"), map) > 0;
        } catch (Exception e) {
            logger.error("ActivityManualPlanDAOImpl.updateStatus happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public boolean updateStatusBefore(ActivityManualPlanDO manualPlan, int status) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", manualPlan.getSlotId());
            map.put("releaseTime", manualPlan.getReleaseTime());
            map.put("status", status);
            return getSqlSession().update(getStamentNameSpace("updateStatusBefore"), map) > 0;
        } catch (Exception e) {
            logger.error("ActivityManualPlanDAOImpl.updateStatus happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public boolean delete(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        try {
            return getSqlSession().delete(getStamentNameSpace("delete"), manualPlan) > 0;
        } catch (Exception e) {
            logger.error("MediaAppMsDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
