package cn.com.duiba.tuia.media.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySlotDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
@Repository("activitySlotDAO")
public class ActivitySlotDAOImpl extends BaseDAO implements ActivitySlotDAO {

    @Override
    public int insertBatch(List<ActivitySlotDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), list);
        } catch (Exception e) {
            logger.error("ActivitySlotDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().delete(getStamentNameSpace("delete"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySlotDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<RspActivitySlotDto> getList(ReqActivitySlotDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getList"), req);
        } catch (Exception e) {
            logger.error("ActivitySlotDAO.getList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int getListAmount(ReqActivitySlotDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("getListAmount"), req);
        } catch (Exception e) {
            logger.error("ActivitySlotDAO.getListAmount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public ActivitySlotDO getBySlotId(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("getBySlotId"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySlotDAO.getBySlotId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(Long slotId, Integer directMode) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("directMode", directMode);
            return getSqlSession().update(getStamentNameSpace("update"), map);
        } catch (Exception e) {
            logger.error("ActivitySlotDAO.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
