package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Function: ActivitySortDAOImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Repository
public class ActivitySortDAOImpl extends BaseDAO implements ActivitySortDAO {

    @Override
    public int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), activitySortDtoList);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.insertBatch data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByCondition"), reqActivitySort);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectByCondition happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectByConditionAmount"), reqActivitySort);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectByConditionAmount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteAllSlotActivity(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().delete(getStamentNameSpace("deleteAllSlotActivity"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.deleteAppAllActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().delete(getStamentNameSpace("deleteActivity"), map);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.deleteActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getActivityForRecommendByApp"), appId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.getActivityForRecommendByApp happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getActivityForRecommendBySlotId"), slotId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.getActivityForRecommendBySlot happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public ActivitySortDto select(Long activitySlotId, Long activityId,
                                  Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("activitySlotId", activitySlotId);
            params.put("activityId", activityId);
            params.put("activityType", activityType);
            return getSqlSession().selectOne(getStamentNameSpace("selectByActivity"), params);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.select happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectSortLocation(Long slotId, Long sort) throws TuiaMediaException {
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("activitySlotId", slotId);
            params.put("activitySort", sort);
            return getSqlSession().selectOne(getStamentNameSpace("selectSortLocation"), params);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectSortLocation happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateSort(Long slotId, Long activityId, Integer activityType, Long sort) throws TuiaMediaException {
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("activitySlotId", slotId);
            params.put("activityId", activityId);
            params.put("activityType", activityType);
            params.put("activitySort", sort);
            return getSqlSession().update(getStamentNameSpace("updateSort"), params);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.updateSort happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateSortBatch(Long slotId, Long startSort, Long step) throws TuiaMediaException {
        try {
            Map<String, Object> params = new HashMap<>();
            params.put("activitySlotId", slotId);
            params.put("startSort", startSort);
            params.put("step", step);
            return getSqlSession().update(getStamentNameSpace("updateSortBatch"), params);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.updateSortBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
