package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;

import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
@Repository("materialSpecificationItemContentDAO")
public class MaterialSpecificationItemContentDAOImpl extends BaseDAO implements MaterialSpecificationItemContentDAO {

    @Override
    public int insertBatch(List<MaterialSpecificationItemContentDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), list);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().delete(getStamentNameSpace("delete"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int itemContentAmount(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().selectOne(getStamentNameSpace("itemContentAmount"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.hasItemContent happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MaterialSpecificationItemContentDO> getByActivity(Long activityId, Integer activityType, Long msId) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            map.put("msId", msId);
            return getSqlSession().selectList(getStamentNameSpace("getByActivity"), map);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemContentDAO.getByActivity happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
