/**
 * Project Name:media-biz File Name:MediaAppConfigDaoImpl.java Package Name:cn.com.duiba.tuia.media.dao.impl
 * Date:2016年10月8日下午7:53:59 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.Date;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppCheckRecordDto;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaAppCheckRecordDao;

/**
 * ClassName:MediaAppConfigDaoImpl <br/>
 * Function: 媒体app账号审核记录. <br/>
 * Date: 2016年10月8日 下午7:53:59 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("mediaAppCheckRecordDao")
public class MediaAppCheckRecordDaoImpl extends BaseDAO implements MediaAppCheckRecordDao {

    @Override
    public int insert(MediaAppCheckRecordDto param) throws TuiaMediaException {
        try {
            param.setGmtCreate(new Date());
            param.setGmtModified(param.getGmtCreate());
            return getSqlSession().insert(getStamentNameSpace("insert"), param);
        } catch (Exception e) {
            logger.error("MediaAppCheckRecordDaoImpl.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
