package cn.com.duiba.tuia.media.parser;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.model.IdAndName;

/**
 * @author xuyenan
 * @createTime 2016/12/28
 */
public final class IdAndNameParser {

    private IdAndNameParser() {
    }

    /**
     * IdAndName parse to MediaAppDto
     * 
     * @param idAndName
     * @return MediaAppDto
     */
    public static MediaAppDto parseToMediaAppDto(IdAndName idAndName) {
        MediaAppDto appDto = new MediaAppDto();
        appDto.setAppId(idAndName.getId());
        appDto.setAppName(idAndName.getName());
        return appDto;
    }
}
