/**
 * Project Name:media-biz<br>
 * File Name:BaseRemoteService.java<br>
 * Package Name:cn.com.duiba.tuia.media.remoteservice<br>
 * Date:2016年9月29日下午2:32:17<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.remoteservice;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: BaseRemoteService <br/>
 * Function: Remote基础服务. <br/>
 * date: 2016年9月29日 下午2:32:17 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class BaseRemoteService {

    /** The logger. */
    protected Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 
     * exceptionFailure:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param e
     * @return
     * @since JDK 1.6
     */
    @ExceptionHandler
    public <T> DubboResult<T> exceptionFailure(Exception e) {
        if (e instanceof TuiaMediaException) {
            TuiaMediaException e1 = (TuiaMediaException) e;
            logger.error("happen TuiaMediaException, because of =[{}]", e1.getResultMessage());
            return DubboResult.failResult(e1.getResultCode(), e1.getResultMessage());
        } else {
            logger.error("happen unKnow error", e);
            return DubboResult.failResult(ErrorCode.E9999999.getErrorCode(), e.getMessage());
        }
    }
}
