package cn.com.duiba.tuia.media.remoteservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.api.dto.ActivityManualPlanDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityManualBackendService;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class RemoteActivityManualBackendServiceImpl  extends BaseRemoteService implements RemoteActivityManualBackendService {

    private static final String TIME_DATE_FORMATE = "yyyy-MM-dd HH:mm";
    
    @Autowired
    private ActivityService       activityService;
    @Autowired
    private ActivityManualService activityManualService;

    @Override
    public DubboResult<Boolean> addActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties(planDto, plan);
            if (planDto.getReleaseTime() != null) {
                plan.setReleaseTime(DateUtils.parseDate(planDto.getReleaseTime(), new String[] {TIME_DATE_FORMATE}));
            }
            return DubboResult.successResult(activityManualService.addActivityManualPlan(plan));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.addActivityManualPlan is error, plan=" + planDto, e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<ActivityManualPlanDto>> findActivityManualPlans(Long slotId) {
        try {
            List<ActivityManualPlanDto> dtoList = new ArrayList<>();
            List<ActivityManualPlanDO> list = activityManualService.findActivityManualPlans(slotId);
            for (ActivityManualPlanDO plan : list) {
                ActivityManualPlanDto planDto = new ActivityManualPlanDto();
                BeanUtils.copyProperties(plan, planDto);
                if (plan.getReleaseTime() != null) {
                    planDto.setReleaseTime(new SimpleDateFormat(TIME_DATE_FORMATE).format(plan.getReleaseTime()));
                }
                String activityName = activityService.getActivityName(plan.getActivityId(), plan.getActivityType());
                planDto.setActivityName(activityName);
                dtoList.add(planDto);
            }
            return DubboResult.successResult(dtoList);
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.findActivityManualPlans is error, slotId=" + slotId, e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> modifyActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties(planDto, plan);
            if (planDto.getReleaseTime() != null) {
                plan.setReleaseTime(DateUtils.parseDate(planDto.getReleaseTime(), new String[] { TIME_DATE_FORMATE }));
            }
            return DubboResult.successResult(activityManualService.modifyActivityManualPlan(plan));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.modifyActivityManualPlan is error, planDto=" + planDto, e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties(planDto, plan);
            if (planDto.getReleaseTime() != null) {
                plan.setReleaseTime(DateUtils.parseDate(planDto.getReleaseTime(), new String[] { TIME_DATE_FORMATE }));
            }
            return DubboResult.successResult(activityManualService.removeActivityManualPlan(plan));
        } catch (Exception e) {
            logger.error("RemoteActivityManualServiceImpl.removeActivityManualPlan is error", e);
            return exceptionFailure(e);
        }
    }
}
