package cn.com.duiba.tuia.media.remoteservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.service.MediaAppService;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMaterialSpecificationBackendService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.MediaAppMsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.util.CollectionUtils;

/**
 * @author xuyenan
 * @createTime 2016/12/26
 */
public class RemoteMaterialSpecificationBackendServiceImpl extends BaseRemoteService implements RemoteMaterialSpecificationBackendService {

    @Autowired
    private MaterialSpecificationService materialSpecificationService;

    @Autowired
    private MediaAppMsService            mediaAppMsService;

    @Autowired
    MediaAppService                      mediaAppService;

    @Override
    public DubboResult<PageResultDto<RspMaterialSpecificationDto>> getMaterialSpecificationList(ReqMaterialSpecificationDto req) {
        try {
            return DubboResult.successResult(new PageResultDto<>(materialSpecificationService.getMaterialSpecificationAmount(req), materialSpecificationService.getMaterialSpecificationList(req),
                                                                 req.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.getMaterialSpecificationList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> deleteMaterialSpecification(Long id) {
        try {
            return DubboResult.successResult(materialSpecificationService.deleteMaterialSpecification(id));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.deleteMaterialSpecification is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspMaterialSpecificationDto> getMaterialSpecificationDetail(Long msId) {
        try {
            return DubboResult.successResult(materialSpecificationService.getMaterialSpecificationDetail(msId));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.getMaterialSpecificationDetail is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addMaterialSpecification(ReqMaterialSpecificationDto req) {
        try {
            return DubboResult.successResult(materialSpecificationService.addMaterialSpecification(req));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.addMaterialSpecification is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus) {
        try {
            return DubboResult.successResult(mediaAppMsService.msDirectToMediaApp(msId, appIds, directStatus));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.msDirectToMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<MediaAppDto>> getMsDirectedMediaApp(Long msId) {
        try {
            List<Long> list = mediaAppMsService.getMsDirectedMediaApp(msId);
            List<MediaAppDto> result = new ArrayList<>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.getMsDirectedMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Map<Long, String>> getMsNameByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(materialSpecificationService.getMsNameByIds(ids));
        } catch (Exception e) {
            logger.error("RemoteMaterialSpecificationBackendService.getMsNameByIds is error", e);
            return exceptionFailure(e);
        }
    }
}
