/**
 * Project Name:media-biz<br>
 * File Name:AccountBankService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年9月30日下午4:01:32<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.domain.AccountBankDto;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: AccountBankService <br/>
 * date: 2016年9月30日 下午4:01:32 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface AccountBankService {

    /**
     * 插入媒体账户银行信息.
     *
     * @param accountBankDto the account bank dto
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    boolean insertAccountBank(AccountBankDto accountBankDto) throws TuiaMediaException;

    /**
     * 通过媒体账户ID获取媒体账户银行信息.
     *
     * @param mediaId the media id
     * @return the account dto
     * @throws TuiaMediaException the tuia media exception
     */
    AccountBankDto selectByMediaId(Long mediaId) throws TuiaMediaException;

    /**
     * 
     * updateAccountBank:(更新媒体银行账户信息). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    boolean updateAccountBank(ReqUpdateAccountBank req) throws TuiaMediaException;
}
