/**
 * Project Name:media-biz<br>
 * File Name:StatisticsService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年10月10日下午4:31:50<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service;

import java.util.List;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;

/**
 * ClassName: StatisticsService <br/>
 * date: 2016年10月10日 下午4:31:50 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface SlotStatisticsService {

    /**
     * 
     * getAdsenseDataAmount:(分页统计广告位数据总数.). <br/>
     *
     * @author ZFZ
     * @param req
     * @param slotIdsList
     * @param appIdsList
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int getAdsenseDataAmount(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList)
                                                                                                     throws TuiaMediaException;

    /**
     * 
     * getAdsenseDataByPage:(分页统计广告位数据.). <br/>
     *
     * @author ZFZ
     * @param req
     * @param slotIdsList
     * @param appIdsList
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<SlotStatisticsDto> getAdsenseDataByPage(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList) throws TuiaMediaException;

    /**
     * 
     * getMediaDataAmount:(分页统计媒体数据总数). <br/>
     *
     * @author ZFZ
     * @param req
     * @param appIdsByName
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int getMediaDataAmount(ReqMediaAppStatisticsDto req, List<Long> appIdsByName) throws TuiaMediaException;

    /**
     * 
     * getMediaDataByPage:(分页统计媒体数据). <br/>
     *
     * @author ZFZ
     * @param req
     * @param appIdsByName
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MediaAppStatisticsDto> getMediaDataByPage(ReqMediaAppStatisticsDto req, List<Long> appIdsByName)
                                                                                                         throws TuiaMediaException;
}
