package cn.com.duiba.tuia.media.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.media.api.constant.ActivityConstant;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAdvertDAO;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityAdvertDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityAdvertCacheService;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
@Service("activityAdvertService")
public class ActivityAdvertServiceImpl implements ActivityAdvertService {

    @Autowired
    private ActivityDAO                activityDAO;

    @Autowired
    private ActivityAdvertDAO          activityAdvertDAO;

    @Autowired
    private ActivityAdvertCacheService activityAdvertCacheService;

    @Override
    public Boolean activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> advertIds) throws TuiaMediaException {
        if (ActivityConstant.IS_DIRECT_ADVERT != directStatus && ActivityConstant.IS_NOT_DIRECT_ADVERT != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (ActivityConstant.DIRECT_ADVERT_MODE_ONLY != directMode && ActivityConstant.DIRECT_ADVERT_MODE_PRIOR != directMode) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        // 更新活动定向广告字段
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDirectAdvert(directStatus);
        activityDto.setDirectAdvertMode(directMode);
        activityDAO.update(activityDto);
        // 活动定向广告更新
        activityAdvertDAO.delete(activityId, activityType);
        if (!CollectionUtils.isEmpty(advertIds)) {
            List<ActivityAdvertDO> list = new ArrayList<>(advertIds.size());
            for (Long advertId : advertIds) {
                ActivityAdvertDO activityAdvertDO = new ActivityAdvertDO();
                activityAdvertDO.setActivityId(activityId);
                activityAdvertDO.setActivityType(activityType);
                activityAdvertDO.setAdvertId(advertId);
                list.add(activityAdvertDO);
            }
            activityAdvertDAO.insertBatch(list);
        }
        activityAdvertCacheService.set(activityId, activityType, advertIds);
        return true;
    }

    @Override
    public List<Long> getActivityAdvertIds(Long activityId, Integer activityType) throws TuiaMediaException {
        return activityAdvertCacheService.get(activityId, activityType);
    }
}
