/**
 * 文件名： EmailServiceImpl.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 下午4:02:48
 */
package cn.com.duiba.tuia.media.service.impl;

import javax.mail.internet.MimeMessage;

import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.velocity.VelocityEngineUtils;

import cn.com.duiba.tuia.media.model.Email;
import cn.com.duiba.tuia.media.service.EmailService;

/**
 * 发送邮件实现类 .
 *
 * @author: leiliang
 * @version:
 */
@Service
public class EmailServiceImpl implements EmailService {

    /** The logger. */
    private Logger         logger = LoggerFactory.getLogger(EmailServiceImpl.class);

    /** The Constant SYSTEM_EMAIL. */
    @Value("${media.email.sys.user.name}")
    private String         systemUserEmail;
    /** The sender. */
    @Autowired
    private JavaMailSender sender;

    /** The velocity engine. */
    @Autowired
    private VelocityEngine velocityEngine;

    @Override
    public void sendWithTemplate(Email email) {
        try {
            MimeMessage mail = sender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mail);
            helper.setTo(email.getTo()); // 发送给谁
            helper.setSubject(email.getSubject()); // 标题
            helper.setFrom(systemUserEmail); // 来自

            String text = VelocityEngineUtils.mergeTemplateIntoString(velocityEngine, email.getTemplateLocation(),
                                                                      "UTF-8", email.getModel());

            helper.setText(text, email.getIsHtml());
            sender.send(mail);
        } catch (Exception e) {
            logger.error("send email failed!", e);
        }
    }
}
