/**
 * Project Name:media-biz<br>
 * File Name:AccountBackendBO.java<br>
 * Package Name:cn.com.duiba.tuia.media.bo<br>
 * Date:2016年9月30日下午3:43:55<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.bo;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.req.ReqRegister;
import cn.com.duiba.tuia.media.model.rsp.AccountInfoRsp;
import cn.com.duiba.tuia.media.model.rsp.RegisterRsp;

/**
 * ClassName: AccountBackendBO <br/>
 * date: 2016年9月30日 下午3:43:55 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface AccountBackendBO {

    /**
     * 媒体账户登录.
     *
     * @param email the email
     * @param password the password
     * @return the result< login rsp>
     * @throws TuiaMediaException the tuia media exception
     */
    Long login(String email, String password) throws TuiaMediaException;

    /**
     * 媒体账户注册.
     *
     * @param req the req
     * @return the register rsp
     * @throws TuiaMediaException the tuia media exception
     */
    RegisterRsp register(ReqRegister req) throws TuiaMediaException;

    /**
     * 获取媒体用户信息.
     *
     * @param mediaId the media id
     * @return the account info
     * @throws TuiaMediaException the tuia media exception
     */
    AccountInfoRsp getAccountInfo(Long mediaId) throws TuiaMediaException;

    /**
     * updateFreezeStatus:(账号冻结). <br/>
     *
     * @author ZFZ
     * @param mediaId
     * @param checkType
     * @param reason
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    boolean updateFreezeStatus(Long mediaId, Integer checkType, String reason) throws TuiaMediaException;

    /**
     * selectAccountByEmail:(通过email查询媒体用户信息). <br/>
     *
     * @param email
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    AccountDto selectAccountByEmail(String email) throws TuiaMediaException;

    /**
     * selectAccountByIds:(通过媒体用户id集合查询用户信息). <br/>
     *
     * @param mediaIds
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountDto> selectAccountByIds(List<Long> mediaIds) throws TuiaMediaException;

}
