/**
 * Project Name:media-manager-biz File Name:AccountMonthReportDAO.java Package Name:cn.com.duiba.tuia.media.manager.dao
 * Date:2016年12月1日下午2:23:30 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.AccountDayReportDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName:AccountMonthReportDAO <br/>
 * Function: 媒体用户月报表DAO. <br/>
 * Date: 2016年12月1日 下午2:23:30 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface AccountDayReportDAO {

    /**
     * selectAppDayBillList:(查询媒体日账单). <br/>
     *
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountDayReportDto> selectAppDayBillList(ReqSlotLineStatisticsByPageDto req) throws TuiaMediaException;

    /**
     * 
     * selectLineData:(查询总的预计收入折现图使用). <br/>
     *
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountDayReportDto> selectLineData(ReqSlotLineStatisticsByPageDto req) throws TuiaMediaException;

}
