package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;

/**
 * Function: ActivityDAO
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivityDAO {

    /**
     * insert
     *
     * @param activityDto
     * @return affect line
     */
    int insert(ActivityDto activityDto) throws TuiaMediaException;

    /**
     * update
     *
     * @param activityDto
     * @return affect line
     */
    int update(ActivityDto activityDto) throws TuiaMediaException;

    /**
     * getList
     *
     * @param req
     * @return 活动列表
     */
    List<ActivityDto> getList(ReqActivityDto req) throws TuiaMediaException;

    /**
     * 数量计算
     *
     * @param req
     * @return 数量
     */
    int getListAmount(ReqActivityDto req) throws TuiaMediaException;

    /**
     * 根据活动ID获取活动列表
     *
     * @param ids 活动ID列表
     * @param actSource 活动来源 0-兑吧 1-推啊
     * @return 活动列表
     */
    List<ActivityDto> getByIds(List<Long> ids, Integer actSource) throws TuiaMediaException;

    /**
     * getDetail
     *
     * @param activityId
     * @param activityType
     * @return ActivityDto
     */
    ActivityDto getDetail(Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * getDetailBySource
     *
     * @param activityId
     * @param source
     * @return ActivityDto
     */
    ActivityDto getDetailBySource(Long activityId, Integer source) throws TuiaMediaException;

    /**
     * getDetail
     *
     * @param activityIds
     * @param activityTypes
     * @return List<ActivityDto>
     */
    List<ActivityDto> getDetail4List(List<Long> activityIds, List<Integer> activityTypes) throws TuiaMediaException;
    
    /**
     * getDetail
     *
     * @param activityIds
     * @param activityTypes
     * @return List<ActivityDto>
     */
    List<ActivityDto> getDetail4ListBySource(List<Long> activityIds, List<Integer> sources) throws TuiaMediaException;

    /**
     * getIdsByName
     * 
     * @param name
     * @return ID列表
     */
    List<Long> getIdsByName(String name) throws TuiaMediaException;

    /**
     * 获取引擎投放列表
     *
     * @return 活动列表
     */
    List<ActivityDto> selectEngineActivityList() throws TuiaMediaException;

    /**
     * 获取试投列表
     *
     * @return 活动列表
     */
    List<ActivityDto> selectNewActivityList() throws TuiaMediaException;

    /**
     * selectActivityIdsByName:(通过活动名称查询活动IDS). <br/>
     *
     * @param activityName
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<Long> selectActivityIdsByName(String activityName) throws TuiaMediaException;

    /**
     * selectBySource:(获取活动列表). <br/>
     *
     * @param source
     * @param limit
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<Long> selectBySource(int source, int limit) throws TuiaMediaException;
}
